<?php

if (!defined("WHMCS"))
    die("This file cannot be accessed directly");

use WHMCS\Database\Capsule;

add_hook('ClientLogout', 1, function($vars) {
    unset($_SESSION['xtreamuserid'], $_SESSION['xtreampasswordhash']);
});
 

function SRXtreamUIPanelCheckMAGexists($params) {
    #Check Stalker MAC exists
    $cart = $_SESSION['cart'];
    foreach ($cart['products'] as $product) {
        $servers = Capsule::table('tblproducts')
                ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
                ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
                ->where('tblproducts.id', '=', $product['pid'])
                ->select('tblservers.*')
                ->get();
        $xtreamConfig = Capsule::table('xtreamuserpanel_Config')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        foreach ($servers as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
            list($sqlhost, $sqlport) = explode(':', $server->ipaddress);
        }
    }
}

add_hook('EmailPreSend', 1, function($vars) {
    $merge_fields = [];
    $GettingPortalLInkDatra = Capsule::table('tblhosting')
            ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
            ->where('tblhosting.id', '=', $vars['relid'])
            ->select('tblproducts.*'
                    , 'tblhosting.id as serviceid'
            )
            ->get();
    if (!empty($GettingPortalLInkDatra)) {
        if ($GettingPortalLInkDatra[0]->servertype == "xtreamUIpanel" && $GettingPortalLInkDatra[0]->configoption12 != "") {
            $merge_fields['portal_url'] = $GettingPortalLInkDatra[0]->configoption12;
            $merge_fields['service_server_hostname'] = $GettingPortalLInkDatra[0]->configoption12;
            return $merge_fields;
        }
    }
}); 